package tomek.java.itjp.concurrent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;


public class ThreadsPoolsDownloader3 {

	private static final Logger log = LogManager.getLogger(ThreadsPoolsDownloader3.class);

	private static final ExecutorService pool = Executors.newFixedThreadPool(5);

	
	private static class MySet {

		private final static Set<Downloader> set = Collections.synchronizedSet(new HashSet<Downloader>());
		private static final int MAXIMUM_ATTEMPT = 3;

		public void add(Downloader setElement) {
			if (set.add(setElement)) {
				setElement.setFuture(pool.submit(setElement));
				log.trace("New element added: "+setElement);
				return;
			}
			Downloader tmp = set.stream().filter(setElement::equals).findAny().orElse(null);
			if (tmp==null) {
				log.fatal("Strange situation... ");
				return;
			}
			if (!tmp.isDone()) {
				log.trace("Waiting for the task...");
				return;
			}
			if (tmp.getValue()!=null) {
				log.trace("Task: "+tmp+" done succesfully: "+tmp.getValue());
				return;
			}
			
			log.trace(tmp+" Error: "+tmp.getError()+" "+tmp.getAttempt());
			if (tmp.isDone() && tmp.getAttempt()<MAXIMUM_ATTEMPT) tmp.setFuture(pool.submit(tmp));
		}
	
		public String toString() {
			return set.toString();
		}

		public void showAll(PrintStream out) {
			out.println("Set contains: "+set.size()+" elements");
			
		}
		
	}
	
	private static class Downloader implements Runnable {
		private final URL url;
				
		private int attempt;
		private String error;
		private String value;
		private Future<?> future;

		public Downloader(URL url) {
			this.url = url;
		}

		public void setFuture(Future<?> submit) {
			future=submit;
		}

		private String readAll(Reader reader) throws IOException {
			StringBuilder builder = new StringBuilder();
			int read = 0;
			while ((read = reader.read()) != -1) {
				builder.append((char) read);
			}
			return builder.toString();
		}

		public void run() {
			attempt++;
			error=null;
			value=null;
			try(Reader reader  = new BufferedReader(new InputStreamReader(url.openStream()));) {					
					value="Read "+readAll(reader).length()+" characters";
			} 
			catch (IOException e) {
				error=e.getMessage();
			}
			//log.trace("Error: "+error+", Value: "+value+", Future: "+future.isDone());			
		}
		
		public String getError() { return error; }
		public String getValue() { return value; }
		public boolean isDone() { return future.isDone(); }
		public int getAttempt() { return attempt; }
		
		public String toString() {
			return this.url.toString();
		}
		
		public boolean equals(Object obj) {
			if (this == obj) return true;
			if (obj == null) return false;
			if (!(obj instanceof Downloader)) return false;
			return Objects.equals(this.url, ((Downloader) obj).url);
		}
		
		public int hashCode() {
			return Objects.hash(this.url);
		}
	}

	
	
	
	public static void main(String[] args) throws MalformedURLException {

		Configurator.initialize(new DefaultConfiguration());
	    Configurator.setRootLevel(Level.TRACE);
	    

		
		String[] addresses = {
				"http://lyngsat.com",
				"http://google.com",
				"http://www.agh.edu.pl",
				"http://www.apple.com/",
				"http://www.cyfraplus.pl",
				"http://www.gazeta.pl",
				"http://www.youtube.com/",
				"http://en.wikipedia.org",
				"http://www.skyscanner.pl",
				"http://www1.tricolor.tv",
				"http://www.w3.org/",
				"http://maps.google.com/",
				"http://www.amazon.com",
				"http://www.manning.com",
				"http://www.oreilly.com",
				"http://forums.macrumors.com",
				"http://www.dziennik.pl",
				"http://www.oracle.com",
				"http://www.wp.pl",
				"http://www.mail.ru",
				"http://www.polets.ru",
				"http://bazy.tomek.it",
				"http://www.whatsmyip.org/http_compression/",
				"http://www.onet.pl",
				"http://www.ovh.pl",
				"http://indect-project.eu",
				"http://david.fullrecall.com/website-optimization",
				"http://stackoverflow.com",
				"http://www.javadocexamples.com/java_source/net/sf/jazzlib/ZipFile.java.html",
				"http://david.fullrecall.com",
				"http://www.shrinkrays.net/code-snippets/csharp/gzip-and-deflate-page-compression-in-asp-net.aspx",
				"http://stackoverflow.com/questions/3017711/apache-deflate-does-it-wait-for-the-whole-page-to-load-first",
				"http://www.orangecoat.com/smaller-and-faster-web-pages-with-gzip-deflate-and-apache",
				"http://support.sas.com/documentation/cdl/en/lrdict/64316/HTML/default/viewer.htm",
				"http://www.ovh.pl",
				"http://indect-project.eu",
				"http://david.fullrecall.com/website-optimization",
				"http://stackoverflow.com",
				"http://www.javadocexamples.com/java_source/net/sf/jazzlib/ZipFile.java.html",
				"http://david.fullrecall.com",
		};

		MySet mySet = new MySet();
		for (String s : addresses)
			mySet.add(new Downloader(new URL(s)));

		try { Thread.sleep(10000); } catch (InterruptedException e) {}

		for (String s : addresses)
			mySet.add(new Downloader(new URL(s)));

		try { Thread.sleep(10000); } catch (InterruptedException e) {}

		for (String s : addresses)
			mySet.add(new Downloader(new URL(s)));
		
		pool.shutdown();
		
		try { Thread.sleep(10000); } catch (InterruptedException e) {}
		mySet.showAll(System.out);

	}
}
